#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "videoinputdlg.h"


QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    MainWindow * pNetBroadcasterDlg = (MainWindow *)(pUserData);

    qDebug("signal removed \n");

    pNetBroadcasterDlg->ui->m_info->setText(QString("INFO : No signal detected"));

    return QCAP_RT_OK;
}

QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    MainWindow * pNetBroadcasterDlg = (MainWindow *)(pUserData);

    qDebug("no signal Detected  \n");

    pNetBroadcasterDlg->ui->m_info->setText(QString("INFO : No signal detected"));

    return QCAP_RT_OK;
}

QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
    MainWindow * pNetBroadcasterDlg = (MainWindow *)(pUserData);

    qDebug("format changed Detected  \n");

    CHAR strVideoInput[ 64 ] = { 0 };

    CHAR strAudioInput[ 64 ] = { 0 };

    CHAR strFrameType[ 64 ] = { 0 };

    pNetBroadcasterDlg->m_nVideoWidth = nVideoWidth;

    pNetBroadcasterDlg->m_nVideoHeight = nVideoHeight;

    pNetBroadcasterDlg->m_bVideoIsInterleaved = bVideoIsInterleaved;

    pNetBroadcasterDlg->m_dVideoFrameRate = dVideoFrameRate;

    pNetBroadcasterDlg->m_nAudioChannels = nAudioChannels;

    pNetBroadcasterDlg->m_nAudioBitsPerSample = nAudioBitsPerSample;

    pNetBroadcasterDlg->m_nAudioSampleFrequency = nAudioSampleFrequency;

    pNetBroadcasterDlg->m_nVideoInput = nVideoInput;

    pNetBroadcasterDlg->m_nAudioInput = nAudioInput;

    UINT nVH = 0;

    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); }

    if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); }

    if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" );}

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" );}

    if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" );}

    if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" );}

    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" );}

    if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" );}

    if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED_AUDIO" );}

    if ( nAudioInput == 1 ) { sprintf( strAudioInput, "LINE_IN" );}

    if ( nAudioInput == 2 ) { sprintf( strAudioInput, "SOUNDCARD_MICROPHONE" );}

    if ( nAudioInput == 3 ) { sprintf( strAudioInput, "SOUNDCARD_LINE_IN" );}

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " ); }

    QString str_info;

    str_info.sprintf("INFO : %d x %d%s @%2.3f FPS , %d CH x %d BITS x %d HZ,  VIDEO INPUT : %s ,  AUDIO INPUT : %s"
                     , nVideoWidth, nVH, strFrameType, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample
                     , nAudioSampleFrequency, strVideoInput, strAudioInput);

    pNetBroadcasterDlg->ui->m_info->setText(str_info);

    return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    return QCAP_RT_OK;
}

QRETURN on_process_preview_audio_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    MainWindow * pNetBroadcasterDlg = (MainWindow *)(pUserData);

    if( pFrameBuffer )
    {
        EnterCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection_audio );

        if( pNetBroadcasterDlg->m_nNetworkServerState_audio > 0x00000000 )
        {
            QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0, pFrameBuffer, nFrameBufferLen, dSampleTime);
        }

        LeaveCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection_audio );
    }

    return QCAP_RT_OK;
}

QRETURN on_process_video_hardware_encoder( PVOID pDevice, UINT iRecNum, double dSampleTime, BYTE * pStreamBuffer, ULONG nStreamBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
    MainWindow * pNetBroadcasterDlg = (MainWindow *)(pUserData);

    if( nStreamBufferLen )
    {
        EnterCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection_video );

        if( pNetBroadcasterDlg->m_nNetworkServerState_video > 0x00000000 )
        {
            QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0, pStreamBuffer, nStreamBufferLen, bIsKeyFrame, dSampleTime);
        }

        LeaveCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection_video );
    }

    return QCAP_RT_OK;
}

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    this->setFixedSize(860, 600);

    this->setWindowTitle("TS over RTP");

    ui->line_URL->setText("rtp://127.0.0.1:1000");

    m_pDevice = NULL;

    m_hNetworkServer = NULL;

    m_nNetworkServerState_audio = 0x00000000;

    m_nNetworkServerState_video = 0x00000000;

    m_nVideoWidth = 0;

    m_nVideoHeight = 0;

    m_bVideoIsInterleaved = FALSE;

    m_dVideoFrameRate = 0.0;

    m_nAudioChannels = 0;

    m_nAudioBitsPerSample = 0;

    m_nAudioSampleFrequency = 0;

    InitializeCriticalSection( &m_hNetworkServerAccessCriticalSection_video);

    InitializeCriticalSection( &m_hNetworkServerAccessCriticalSection_audio);

    ui->pushBTN_Start->setEnabled(true);

    ui->pushBTN_Stop->setEnabled(false);

    HwInitialize();
}

MainWindow::~MainWindow()
{
    HwUninitialize();

    delete ui;
}

void MainWindow::HwInitialize()
{
    //CREATE CAPTURE DEVICE

    QCAP_CREATE( "MZ0380 PCI", 0, (HWND)ui->frame->winId(), &m_pDevice, TRUE);

    QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevice, on_process_no_signal_detected, this );

    QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevice, on_process_signal_removed, this );

    QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevice, on_process_format_changed, this );

    QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice, on_video_preview_callback, this );

    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice, on_process_preview_audio_buffer, this );

    QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( m_pDevice, 0, on_process_video_hardware_encoder, this );

    QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( m_pDevice, 0, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, 0, 0, 0 );

    QCAP_SET_VIDEO_INPUT( m_pDevice, QCAP_INPUT_TYPE_SDI);

    QCAP_SET_AUDIO_SOUND_RENDERER(m_pDevice, 0);

    QCAP_SET_AUDIO_INPUT( m_pDevice, QCAP_INPUT_TYPE_EMBEDDED_AUDIO);

    QCAP_RUN( m_pDevice );
}

void MainWindow::HwUninitialize()
{
    //DESTROY CAPTURE DEVICE

    on_pushBTN_Stop_clicked();

    if( m_pDevice ) {

        QCAP_STOP( m_pDevice );

        QCAP_DESTROY( m_pDevice );

        m_pDevice = NULL;
    }

    DeleteCriticalSection( &m_hNetworkServerAccessCriticalSection_audio );

    DeleteCriticalSection( &m_hNetworkServerAccessCriticalSection_video );
}

void MainWindow::on_pushBTN_Input_clicked()
{
    VideoInputDlg video_input(this);

    video_input.exec();
}

void MainWindow::on_pushBTN_Start_clicked()
{
    if( (m_nVideoWidth == 0) || (m_nVideoHeight == 0) ) { return; }

    QString URL = ui->line_URL->text();

    QCAP_CREATE_BROADCAST_TS_OVER_RTP_SERVER(0, URL.toLatin1().data(), &m_hNetworkServer);

    QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYPE_YV12, m_nVideoWidth, m_nVideoHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

    QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC_ADTS, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency);

    QCAP_START_BROADCAST_SERVER( m_hNetworkServer );

    EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_audio );

    m_nNetworkServerState_audio = 0x00000001;

    LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_audio );

    EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_video );

    m_nNetworkServerState_video = 0x00000001;

    LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_video );

    ui->pushBTN_Start->setEnabled(false);

    ui->pushBTN_Stop->setEnabled(true);
}

void MainWindow::on_pushBTN_Stop_clicked()
{
    if( m_hNetworkServer!= NULL )
    {
        EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_audio );

        m_nNetworkServerState_audio = 0x00000000;

        LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_audio );

        EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_video );

        m_nNetworkServerState_video = 0x00000000;

        LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_video );

        QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer );

        QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer );

        m_hNetworkServer = NULL;

        ui->pushBTN_Start->setEnabled(true);

        ui->pushBTN_Stop->setEnabled(false);
    }
}
